<?php

namespace App\Modules\Legal\Migrations\ExecutionDecisions;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExecutionDecisions extends Model 
{

    protected $table = 'legal_execution_decisions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function execution()
    {
        return $this->belongsTo('CompanyLawsuitExecutions', 'execution_id');
    }

    public function decision()
    {
        return $this->belongsTo('Decisions', 'decision_id');
    }

}